# Proyecto 3.1. Dos cuadrados, pero más fáciles 

A) La idea es que de nuevo dibujes dos cuadrados rojos, como en la actividad 
_“Programo el cuadrado, programo el cuadrado”_, pero en esta ocasión te pedimos que 
encuentres una forma de definir tus propios comandos; en el proyecto vas a encontrar una ayuda. 
Indagá cómo completar las partes que ya vienen empezadas, y cómo usarlas. 
El tablero final es igual que el que pedía la actividad mencionada. 
Al terminar con esta parte, fijate que hay una segunda parte.

<center>
![Tablero final esperado en la parte 1](data:image/png;base64,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)
</center>

> **El dato**
>
> El programa principal es la parte del código que la máquina busca para empezar a ejecutar. 
> Un programa siempre está formado por muchos procedimientos y un programa principal. 

.

> **Recordatorio**
>
> Un comando es la descripción de una acción. 
> Puede ser un comando primitivo o uno que haya sido definido mediante un procedimiento. 
> Y puesto que los comandos describen acciones, cuando definimos un comando nuevo, elegimos como 
> nombre algo que empieza con un verbo, al igual que los nombres de los comandos primitivos: dibujar, 
> poner, mover, etcétera. 

B) Después de guardar tu solución en la computadora, cambiá el programa para que dibuje cuatro 
   cuadrados, como en la figura. 
   La parte más complicada es la de mover el cabezal hasta donde hay que empezar a dibujar… 
   ¡pero para dibujar el cuadrado ya tenés tu propio comando!

<center>
![Tablero final esperado en la parte 2](data:image/png;base64,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)
</center>

> **Reutilizar es la clave**
>
> Reutilizar es aprovechar un programa o procedimiento ya hecho para no tener que hacerlo todo de nuevo, 
> y solamente hacerle pequeñas modificaciones para ajustarlo al nuevo problema.

[Enunciado en PDF][PDF]

[PDF]: https://raw.githubusercontent.com/gobstones/curso-InPr-UNQ/master/Proyectos/2.Procedimientos/1.3.Dos%20cuadrados%2C%20pero%20m%C3%A1s%20f%C3%A1ciles/assets/resources/description.pdf "Enunciado de 'Dos cuadrados, pero más fáciles' en PDF"
